<?php
/*============================================================================*\
|| ########################################################################## ||
|| # Ultimate Media Gallery v1.4.3                                          # ||
|| #                                                                        # ||
|| # ---------------------------------------------------------------------- # ||
|| # Copyright  2008-2009 pHp-unlimited. All Rights Reserved.              # ||
|| # This file may not be redistributed in whole or significant part.       # ||
|| # It's not allowed to delete this Information.                           # ||
|| ########################################################################## ||
\*============================================================================*/

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting (E_ALL & ~E_NOTICE);

@ignore_user_abort (true);
if (@ini_get ('safe_mode') != 1)
{
	@set_time_limit (0);
	@ini_set ('max_execution_time', 0);
}
@ini_set ('memory_limit', '128M');
@ini_set ('post_max_size', '30M');
@ini_set ('upload_max_filesize', '30M');
@ini_set ('magic_quotes_runtime', false);
@ini_set ('magic_quotes_sybase', false);

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array ('umg');
$specialtemplates = array ();

// ########################## REQUIRE BACK-END ############################
require_once ('./global.php');
require_once (DIR.'/umg_gallery/umg_functions.php');

// ######################## CHECK ADMIN PERMISSIONS #######################
if (!can_administer ('canadminumg')) print_cp_no_permission();

// ############################# LOG ACTION ###############################
log_admin_action ();

// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################

print_cp_header ($vbphrase['umg_title']);

if (empty ($_REQUEST['do'])) $_REQUEST['do'] = 'permission';

$vbulletin->input->clean_array_gpc('r', array(
	'f'         => TYPE_INT,
	'send'      => TYPE_STR,
	'perpage'   => TYPE_UINT,
	'startat'   => TYPE_UINT,
	'fieldtype' => TYPE_INT,
	'custom_t'  => TYPE_ARRAY,
	'custom_i'  => TYPE_ARRAY_INT
));

$field_array = array (
	1 => $vbphrase['umg_admin_fieldtype_1'],
	2 => $vbphrase['umg_admin_fieldtype_2'],
	3 => $vbphrase['umg_admin_fieldtype_3'],
	4 => $vbphrase['umg_admin_fieldtype_4'],
	5 => $vbphrase['umg_admin_fieldtype_5'],
	6 => $vbphrase['umg_admin_fieldtype_6']
);

$doactive = 1;
$dosave = 'savecustom';
if ($_REQUEST['do'] == 'profile')
{
	if (!$vbulletin->products['umgprofile'])
	{
		print_cp_message ($vbphrase['umg_feature_not_installed']);
	}
	else
	{
		if ($vbulletin->GPC['send'] == 'send')
		{
			$vbulletin->input->clean_array_gpc('r', array(
				'media_row'    => TYPE_INT,
				'media_count'  => TYPE_INT,
				'media_size'   => TYPE_STR,
				'show_info'    => TYPE_INT,
				'sort_by'      => TYPE_INT,
				'only_private' => TYPE_INT,
			));
			$media_row = $vbulletin->GPC['media_row'];
			if ($media_row <= 0) $media_row = 1;

			$media_count = $vbulletin->GPC['media_count'];
			if ($media_count < 0) $media_count = 0;

			$size = trim (strtolower ($vbulletin->GPC['media_size']));
			if ($size != 's' AND $size != 'm' AND $size != 'o') $size = 's';

			$psettings = $db->query_first ("SELECT * FROM " . TABLE_PREFIX . "umg_profile_settings");
			if ($psettings['id'])
			{
				$db->query_write ("UPDATE " . TABLE_PREFIX . "umg_profile_settings SET
					`media_row`   =" . $media_row . ",
					`media_count` =" . $media_count . ",
					`media_size`  ='" .  $size .  "',
					`sort_by`     =" . $vbulletin->GPC['sort_by'] . ",
					`show_info`   =" . $vbulletin->GPC['show_info'] . ",
					`only_private`=" . $vbulletin->GPC['only_private']
				);
			}
			else
			{
				$db->query_write ("INSERT INTO " . TABLE_PREFIX . "umg_profile_settings
					(`id`,`media_row`,`media_count`,`media_size`,`show_info`,`only_private`) 
					VALUES 
					(1," . $media_row . "," . $media_count . ",'" . $size . "'," . $vbulletin->GPC['show_info'] . "," . $vbulletin->GPC['only_private'] . ")
				");
			}
			umg_create_datastore ('psettings');
		}

		$psettings = $db->query_first ("SELECT * FROM " . TABLE_PREFIX . "umg_profile_settings");
		$sort_array = array (
			$vbphrase['umg_admin_profile_latest'],
			$vbphrase['umg_admin_profile_rated'],
			$vbphrase['umg_admin_profile_hits'],
			$vbphrase['umg_admin_profile_comments']
		);

		print_form_header ('umg_admin', 'profile');
		construct_hidden_code ('send', 'send');
		print_table_header ($vbphrase['umg_admin_profile_settings'], 2);
		print_description_row ($vbphrase['umg_admin_profile_settings_desc'], 0, 2);

		print_input_row ($vbphrase['umg_admin_profile_rows'], 'media_row', $psettings['media_row'], 1, 30, 5);
		print_input_row ($vbphrase['umg_admin_profile_images'], 'media_count', $psettings['media_count'], 1, 30, 5);
		print_input_row ($vbphrase['umg_admin_profile_size'], 'media_size', $psettings['media_size'], 1, 30, 1);
		print_select_row ($vbphrase['umg_admin_profile_sort'], 'sort_by', $sort_array, $psettings['sort_by']);
		print_yes_no_row ($vbphrase['umg_admin_profile_info'], 'show_info', $psettings['show_info']);
		print_yes_no_row ($vbphrase['umg_admin_profile_private'], 'only_private', $psettings['only_private']);

		print_submit_row ($vbphrase['umg_admin_save']);
	}
}

if ($_REQUEST['do'] == 'delete')
{

	if ($vbulletin->GPC['send'] == 'send')
	{
		if (!$vbulletin->GPC['f'])
		{
			print_cp_message ($vbphrase['umg_admin_invalid_id']);
		}
		else
		{
			$db->query_write ("DELETE FROM " . TABLE_PREFIX . "umg_custom WHERE id=" . $vbulletin->GPC['f']);
			$db->query_write ("DELETE FROM " . TABLE_PREFIX . "umg_customfield WHERE customid=" . $vbulletin->GPC['f']);
			$db->query ("OPTIMIZE TABLE " . TABLE_PREFIX . "umg_custom");
			$db->query ("OPTIMIZE TABLE " . TABLE_PREFIX . "umg_customfield");
			umg_create_datastore ('fields');
			$_REQUEST['do'] = 'custom';
		}
	}
	else
	{
		print_form_header ('umg_admin', 'delete');
		construct_hidden_code ('send', 'send');
		construct_hidden_code ('f', $vbulletin->GPC['f']);
		print_table_header ($vbphrase['umg_admin_custom_field_delete'], 1);
		print_description_row ($vbphrase['umg_admin_custom_field_delete_desc'], 0, 1);
		print_submit_row ($vbphrase['umg_admin_delete_field'], '', 1, $vbphrase['go_back']);
	}

}
else if ($_REQUEST['do'] == 'choosetype')
{

	print_form_header ('umg_admin', 'docustom');
	print_table_header ($vbphrase['umg_admin_choose_field_type'], 2);
	print_select_row ($vbphrase['umg_admin_choose_field_type_desc'], 'fieldtype', $field_array, '');
	print_submit_row ($vbphrase['umg_admin_continue'], '', 2, $vbphrase['go_back']);

}
else if ($_REQUEST['do'] == 'upgradecustom')
{

	if (!$vbulletin->GPC['f'])
	{
		print_cp_message ($vbphrase['umg_admin_invalid_id']);
	}
	else
	{
		if (!empty ($vbulletin->GPC['custom_t']))
		{
			foreach ($vbulletin->GPC['custom_t'] AS $key => $val)
			{
				$$key = $val;			
			}
		}
		if (!empty ($vbulletin->GPC['custom_i']))
		{
			foreach ($vbulletin->GPC['custom_i'] AS $key => $val)
			{
				$$key = $val;
			}
		}
		if (!$name OR $name == '') print_cp_message ($vbphrase['umg_admin_enter_field_name']);
		if (!$title OR $title == '') print_cp_message ($vbphrase['umg_admin_enter_field_title']);
		if (!$size) $size = 0;
		if (!$length) $length = 0;
		if (!$sortorder) $sortorder = 0;

		$db->query_write ("UPDATE " . TABLE_PREFIX . "umg_custom SET 
			`title`      ='" . $db->escape_string (addslashes ($title)) . "',
			`description`='" . $db->escape_string (addslashes ($description)) . "',
			`default`    ='" . $db->escape_string (addslashes ($default)) . "',
			`length`     =" . $length . ",
			`size`       =" . $size . ",
			`sortorder`  =" . $sortorder . ",
			`active`     =" . $active . " 
			WHERE id=" . $vbulletin->GPC['f']
		);

		umg_create_datastore ('fields');

		define('CP_REDIRECT', 'umg_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=custom');
		if (defined('CP_CONTINUE')) define('CP_REDIRECT', CP_CONTINUE);
		print_cp_message ($vbphrase['umg_admin_field_changed'], CP_REDIRECT, 1, defined('CP_BACKURL') ? CP_BACKURL : NULL, defined('CP_CONTINUE') ? true : false);
	}

}
else if ($_REQUEST['do'] == 'edit')
{

	if (!$vbulletin->GPC['f'])
	{
		print_cp_message ($vbphrase['umg_admin_choose_field_first']);
	}
	else
	{
		$field = $db->query_first ("SELECT * FROM " . TABLE_PREFIX . "umg_custom WHERE id=" . $vbulletin->GPC['f']);
		if ($field['id'])
		{
			foreach ($field as $key => $val)
			{
				$$key = $val;
			}
			$dosave = 'upgradecustom';
			$doactive = $field['active'];
			$vbulletin->GPC['fieldtype'] = $field['fieldtype'];
			$_REQUEST['do'] = 'docustom';
		}
		else
		{
			print_cp_message ($vbphrase['umg_admin_invalid_id']);
		}
	}

}
else if ($_REQUEST['do'] == 'savecustom')
{

	if ($vbulletin->GPC['fieldtype'])
	{
		if (!empty ($vbulletin->GPC['custom_t']))
		{
			foreach ($vbulletin->GPC['custom_t'] AS $key => $val)
			{
				$$key = $val;			
			}
		}
		if (!empty ($vbulletin->GPC['custom_i']))
		{
			foreach ($vbulletin->GPC['custom_i'] AS $key => $val)
			{
				$$key = $val;
			}
		}
		if (!$name OR $name == '') print_cp_message ($vbphrase['umg_admin_enter_field_name']);
		if (!$title OR $title == '') print_cp_message ($vbphrase['umg_admin_enter_field_title']);
		if (!$size) $size = 0;
		if (!$length) $length = 0;
		if (!$sortorder) $sortorder = 0;

		$db->query_write ("INSERT INTO " . TABLE_PREFIX . "umg_custom 
			(`fieldtype`,`name`,`title`,`description`,`default`,`length`,`size`,`sortorder`,`active`) 
			VALUES 
			(" . $vbulletin->GPC['fieldtype'] . ",'" . $db->escape_string (addslashes ($name)) . "','" . $db->escape_string (addslashes ($title)) . "','" . $db->escape_string (addslashes ($description)) . "','" . $db->escape_string (addslashes ($default)) . "'," . $length . "," . $size . "," . $sortorder . "," . $active . ")
		");

		umg_create_datastore ('fields');

		define('CP_REDIRECT', 'umg_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=custom');
		if (defined('CP_CONTINUE')) define('CP_REDIRECT', CP_CONTINUE);
		print_cp_message ($vbphrase['umg_admin_field_added'], CP_REDIRECT, 1, defined('CP_BACKURL') ? CP_BACKURL : NULL, defined('CP_CONTINUE') ? true : false);
	}
	else
	{
		print_cp_message ($vbphrase['umg_admin_choose_fieldtype_first']);
	}
}

if ($_REQUEST['do'] == 'categories')
{
}
else if ($_REQUEST['do'] == 'rebuildcache')
{

	umg_create_datastore ('stats');
	umg_create_datastore ('ecard');
	umg_create_datastore ('extensions');
	umg_create_datastore ('fields');
	umg_create_datastore ('counter_private');
	umg_create_datastore ('counter_public');

	define('CP_REDIRECT', 'umg_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=maintenance');
	if (defined('CP_CONTINUE')) define('CP_REDIRECT', CP_CONTINUE);
	print_cp_message ($vbphrase['umg_admin_cache_rebuilded'], CP_REDIRECT, 1, defined('CP_BACKURL') ? CP_BACKURL : NULL, defined('CP_CONTINUE') ? true : false);

}
if ($_REQUEST['do'] == 'categorycount')
{

	$cats = $db->query_read ("SELECT 
		* 
		FROM " . TABLE_PREFIX . "umg_category 
		WHERE catid>=" . $vbulletin->GPC['startat'] . " 
		LIMIT " . $vbulletin->GPC['perpage']
	);

	$finishat = $vbulletin->GPC['startat'];

	while ($cat = $db->fetch_array ($cats))
	{
		echo construct_phrase ($vbphrase['processing_x'], $cat['catid']) . "<br />\n";

		umg_correct_counts ($cat['catid']);
		flush ();

		$finishat = ($cat['catid'] > $finishat ? $cat['catid'] : $finishat);
	}

	if ($finishat != $vbulletin->GPC['startat'])
	{
		$finishat++;
		$checkmore = $db->query_first("SELECT catid FROM " . TABLE_PREFIX . "umg_category WHERE catid>=" . $finishat . " LIMIT 1");
	}
	else $checkmore = 0;

	if ($checkmore)
	{
		print_cp_redirect("umg_admin.php?" . $vbulletin->session->vars['sessionurl'] . "do=categorycount&startat=" . $finishat . "&pp=" . $vbulletin->GPC['perpage']);
		echo "<p><a href=\"umg_admin.php?" . $vbulletin->session->vars['sessionurl'] . "do=categorycount&amp;startat=" . $finishat . "&amp;pp=" . $vbulletin->GPC['perpage'] . "\">" . $vbphrase['click_here_to_continue_processing'] . "</a></p>";
	}
	else
	{
		umg_create_datastore ('stats');
		umg_create_datastore ('counter_private');
		umg_create_datastore ('counter_public');

		define('CP_REDIRECT', 'umg_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=maintenance');
		print_stop_message ('umg_admin_categorycount_ok');
	}

}
else if ($_REQUEST['do'] == 'maintenance')
{

	print_form_header ('umg_admin', 'rebuildcache');
	print_table_header ($vbphrase['umg_admin_cache_rebuild'], 2);
	print_description_row ($vbphrase['umg_admin_cache_rebuild_desc'], 0, 2);
	print_submit_row ($vbphrase['update']);

	print_form_header ('umg_admin', 'categorycount');
	print_table_header ($vbphrase['umg_admin_catcount'], 2);
	construct_hidden_code ('typecount', 'category');
	print_description_row ($vbphrase['umg_admin_catcount_desc'], 0, 2);
	print_input_row ($vbphrase['umg_admin_catcount_pp'], 'perpage', 10, 1, 30);
	print_submit_row ($vbphrase['update']);

}
else if ($_REQUEST['do'] == 'docustom')
{

	$ftype = $vbulletin->GPC['fieldtype'];
	print_form_header ('umg_admin', $dosave);
	construct_hidden_code ('fieldtype', $ftype);
	construct_hidden_code ('f', $vbulletin->GPC['f']);
	print_table_header ($vbphrase['umg_admin_custom_fields'], 2);
	print_label_row ($vbphrase['umg_admin_field_type'], '<i>' . $field_array["$ftype"] . '</i>');
	if ($dosave == 'upgradecustom')
	{
		print_label_row ($vbphrase['umg_admin_field_name'], '<i>' . $name . '</i>');
		construct_hidden_code ('custom_t[name]', $name);
	}
	else
	{
		print_input_row ($vbphrase['umg_admin_field_name_input'], 'custom_t[name]', $name, 1, 30);
	}
	print_input_row ($vbphrase['umg_admin_field_title_input'], 'custom_t[title]', $title, 1, 30);
	print_input_row ($vbphrase['umg_admin_field_description_input'], 'custom_t[description]', $description, 1, 30);

	// text for different fieldtype
	if ($vbulletin->GPC['fieldtype'] == 1)
	{
		print_input_row ($vbphrase['umg_admin_field_default_value'], 'custom_t[default]', $default, 1, 30);
		print_input_row ($vbphrase['umg_admin_field_length'], 'custom_i[length]', 100, 1, 30);
	}
	else if ($vbulletin->GPC['fieldtype'] == 2)
	{
		if (!$size) $size = 6;
		if (!$length) $length = 40;
		print_textarea_row ($vbphrase['umg_admin_field_default_value'], 'custom_t[default]', $default);
		print_input_row ($vbphrase['umg_admin_field_display_width'], 'custom_i[length]', $length, 1, 30);
		print_input_row ($vbphrase['umg_admin_field_display_height'], 'custom_i[size]', $size, 1, 30);
	}
	else if ($vbulletin->GPC['fieldtype'] == 3)
	{
		if (!$length) $length = 0;
		print_textarea_row ($vbphrase['umg_admin_field_options'], 'custom_t[default]', $default);
		print_input_row ($vbphrase['umg_admin_custom_field_radio'], 'custom_i[length]', $length, 1, 30);
	}
	else if ($vbulletin->GPC['fieldtype'] == 4)
	{
		if (!$size) $size = 2;
		if (!$length) $length = 0;
		print_textarea_row ($vbphrase['umg_admin_field_options'], 'custom_t[default]', $default);
		print_input_row ($vbphrase['umg_admin_custom_field_checkbox'], 'custom_i[length]', $length, 1, 30);
		print_input_row ($vbphrase['umg_admin_custom_field_checkbox_limit'], 'custom_i[size]', $size, 1, 30);
	}
	else if ($vbulletin->GPC['fieldtype'] == 5)
	{
		if (!$length) $length = 6;
		print_textarea_row ($vbphrase['umg_admin_field_options'], 'custom_t[default]', $default);
		print_input_row ($vbphrase['umg_admin_custom_field_dheight'], 'custom_i[length]', $length, 1, 30);
	}
	else if ($vbulletin->GPC['fieldtype'] == 6)
	{
		if (!$length) $length = 6;
		print_textarea_row ($vbphrase['umg_admin_field_options'], 'custom_t[default]', $default);
		print_input_row ($vbphrase['umg_admin_custom_field_dheight'], 'custom_i[length]', $length, 1, 30);
	}

	if (!$sortorder) $sortorder = 1;
	print_input_row ($vbphrase['umg_admin_custom_field_sortorder'], 'custom_i[sortorder]', $sortorder, 1, 30);
	print_yes_no_row ($vbphrase['umg_admin_custom_field_active'], 'custom_i[active]', $doactive);
	print_submit_row ($vbphrase['umg_admin_field_save'], '_default_' , 2, $vbphrase['go_back']);
}
else if ($_REQUEST['do'] == 'custom')
{

	print_form_header ('umg_admin', 'choosetype');
	construct_hidden_code ('send', 'send');
	print_table_header ($vbphrase['umg_admin_add_custom_field'], 4);
	print_description_row ($vbphrase['umg_admin_add_custom_field_desc'], 0, 4);

	$customs = $db->query_read ("SELECT * FROM " . TABLE_PREFIX . "umg_custom ORDER BY sortorder ASC");
	if ($db->num_rows ($customs))
	{
		print_cells_row (array ($vbphrase['umg_admin_field_title'], $vbphrase['umg_admin_field_type'], '<nobr>' . $vbphrase['umg_admin_field_displayorder'] . '</nobr>', $vbphrase['controls']), 1, '', -1);
		while ($custom = $db->fetch_array ($customs))
		{
			$ftype = $custom['fieldtype'];
			$bgclass = fetch_row_bgclass();
			echo "
<tr>
 <td class=\"$bgclass\" width=\"70%\">" . $custom['title'] . "</td>
 <td class=\"$bgclass\" width=\"30%\">" . $field_array["$ftype"] . "</td>
 <td class=\"$bgclass\" align=\"center\"><span class=\"smallfont\">" . $custom['sortorder'] . "</span></td>
 <td class=\"$bgclass\"><nobr>" . "[<a href=\"umg_admin.php?" . $vbulletin->session->vars['sessionurl'] . "do=edit&f=" . $custom['id'] . "\">" . $vbphrase['edit'] . "</a>]" . " " . "[<a href=\"umg_admin.php?" . $vbulletin->session->vars['sessionurl'] . "do=delete&f=" . $custom['id'] . "\">" . $vbphrase['delete'] . "</a>]" .
 "</nobr></td>
				</tr>
			";
		}
	}
	else
	{
		// empty
	}
	print_submit_row ($vbphrase['umg_admin_add_field'], false, 4);

}
else if ($_REQUEST['do'] == 'permission')
{

	$read = array ('editcomments', 'deletecomments', 'addcat', 'editcat', 'deletecat', 'deletemedia');

	if ($_REQUEST['send'] == 'send')
	{
		$vbulletin->input->clean_array_gpc('r', array(
			'1' => TYPE_ARRAY_UINT,
			'2' => TYPE_ARRAY_UINT,
			'3' => TYPE_ARRAY_UINT,
		));
		for ($umgid = 1; $umgid < 4; $umgid++)
		{
			$upgrade = array ();
			foreach ($vbulletin->GPC["$umgid"] AS $key => $val)
			{
				$upgrade[] = '`' . $db->escape_string ($key) . '`=' . intval ($val);
			}
			$db->query_write ("UPDATE " . TABLE_PREFIX . "umg_usergroup SET " . implode (',', $upgrade) . " WHERE umgid=" . $umgid);
		}
	}

	print_form_header ('umg_admin', 'permission');
	construct_hidden_code ('send', 'send');
	print_table_header ($vbphrase['umg_admin_umg_permission'], 2);
	print_description_row ($vbphrase['umg_admin_umg_permission_desc'], 0, 2);

	$id = 0;
	$desc = array (
		$vbphrase['umg_admin_can_edit_comments'],
		$vbphrase['umg_admin_can_delete_comments'],
		$vbphrase['umg_admin_can_create_categories'],
		$vbphrase['umg_admin_can_edit_categories'],
		$vbphrase['umg_admin_can_delete_categories'],
		$vbphrase['umg_admin_can_delete_medias']
	);
	$permissions = $db->query_read ("SELECT * FROM " . TABLE_PREFIX . "umg_usergroup ORDER BY umgid ASC");
	while ($permission = $db->fetch_array ($permissions))
	{
		if ($permission['umgid'] != $id)
		{
			$id = $permission['umgid'];
			echo '<tr><td class="optiontitle" title="' . $permission['gtitle'] . '" colspan="2"><div>' . $permission['gtitle'] . '</div></td></tr>';
		}
		foreach ($read AS $key => $val)
		{
			print_yes_no_row ($desc["$key"], $id . '[' . $val . ']', $permission["$val"]);
		}
	}

	print_submit_row ($vbphrase['umg_admin_save'], false, 2);

}
else if ($_REQUEST['do'] == 'mediasizes')
{

	if ($_REQUEST['send'] == 'send')
	{
		$vbulletin->input->clean_array_gpc('r', array(
			'ext'  => TYPE_ARRAY_UINT,
		));
		$width = $height = 0;
		foreach ($vbulletin->GPC['ext'] AS $key => $val)
		{
			if (ereg ('_width', $key))
			{
				$where = str_replace ('_width', '', $key);
				$width = ($val ? $val : 1);
			}
			else if (ereg ('_height', $key))
			{
				$where = str_replace ('_height', '', $key);
				$height = ($val ? $val : 1);
			}
			if ($width AND $height)
			{
				$db->query_write ("UPDATE " . TABLE_PREFIX . "umg_extensions SET width=" . $width . ", height=" . $height . " WHERE extension='" . $db->escape_string ($where) . "'");
				$width = $height = 0;
			}
		}
		umg_create_datastore ('umg_extensions');
	}

	print_form_header ('umg_admin', 'mediasizes');
	construct_hidden_code ('send', 'send');
	print_table_header ($vbphrase['umg_admin_media_sizes'], 3);
	print_description_row ($vbphrase['umg_admin_media_sizes_desc'], 0, 3);
	print_cells_row (array ($vbphrase['umg_admin_extension'], $vbphrase['umg_admin_width'], $vbphrase['umg_admin_height']), 1, 'tcat');

	$extensions = $db->query_read ("SELECT * FROM " . TABLE_PREFIX . "umg_extensions ORDER BY extension ASC");
	while ($extension = $db->fetch_array ($extensions))
	{
		$ext = $extension['extension'];
		print_cells_row (array (
			$ext,
			'<input type="text" class="bginput" name="ext[' . $ext . '_width]" id="it_ext[' . $ext . '_width]_4" value="' . $extension['width'] . '" size="30" dir="ltr" tabindex="1" title="name=&quot;ext[' . $ext . '_width]&quot;" />',
			'<input type="text" class="bginput" name="ext[' . $ext . '_height]" id="it_ext[' . $ext . '_height]_4" value="' . $extension['height'] . '" size="30" dir="ltr" tabindex="1" title="name=&quot;ext[' . $ext . '_height]&quot;" />'
		));
	}
	$db->free_result ($extensions);

	print_submit_row ($vbphrase['umg_admin_save'], false, 3);

}
else if ($_REQUEST['do'] == 'rebuild')
{

	print_form_header ('umg_admin', 'rebuild_thumbs', 0, 1, 'vbform');
	print_table_header ($vbphrase['umg_admin_new_thumbnails'], 2);
	print_description_row ($vbphrase['umg_admin_new_thumbnails_desc'], 0, 2);
	print_input_row ($vbphrase['umg_admin_number_per_cycle'], 'perpage', 50, 1, 30);
	print_submit_row ($vbphrase['umg_admin_create']);

}
else if ($_REQUEST['do'] == 'rebuild_thumbs')
{

	$thumbs = $db->query_read ("SELECT
		m.*,c.userid AS gallery,c.title as ctitle 
		FROM " . TABLE_PREFIX . "umg_media AS m 
		LEFT JOIN " . TABLE_PREFIX . "umg_category AS c ON (c.catid=m.catid) 
		WHERE m.mediaid>=" . $vbulletin->GPC['startat'] . "
		AND c.catid IS NOT NULL 
		ORDER BY m.mediaid ASC 
		LIMIT " . $vbulletin->GPC['perpage']
	);

	$finishat = $vbulletin->GPC['startat'];

	while ($thumb = $db->fetch_array ($thumbs))
	{
		echo construct_phrase ($vbphrase['processing_x'], $thumb['mediaid']) . "<br />\n";

		$extension = $thumb['filetype'];
		if (!in_array ($extension, array ('gif', 'jpg', 'jpeg', 'png')))
		{
			$file = explode ('.', $thumb['filename']);
			$extension = array_pop ($file);
		}
		umg_create_thumbnails ($extension, $thumb['mediaid'] . '_' . $thumb['filename'], $thumb['gallery'], 'small', array ('width' => $vbulletin->options['umgtn_smallw'], 'height' => $vbulletin->options['umgtn_smallh']), 75, $thumb['mediaid']);
		umg_create_thumbnails ($extension, $thumb['mediaid'] . '_' . $thumb['filename'], $thumb['gallery'], 'medium', array ('width' => $vbulletin->options['umgtn_mediumw'], 'height' => $vbulletin->options['umgtn_mediumh']), 75, $thumb['mediaid']);

		flush ();

		$finishat = ($thumb['mediaid'] > $finishat ? $thumb['mediaid'] : $finishat);
	}

	if ($finishat != $vbulletin->GPC['startat'])
	{
		$finishat++;
		$checkmore = $db->query_first("SELECT mediaid FROM " . TABLE_PREFIX . "umg_media WHERE mediaid>=" . $finishat . " LIMIT 1");
	}
	else $checkmore = 0;

	if ($checkmore)
	{
		print_cp_redirect("umg_admin.php?" . $vbulletin->session->vars['sessionurl'] . "do=rebuild_thumbs&startat=" . $finishat . "&pp=" . $vbulletin->GPC['perpage']);
		echo "<p><a href=\"umg_admin.php?" . $vbulletin->session->vars['sessionurl'] . "do=rebuild_thumbs&amp;startat=" . $finishat . "&amp;pp=" . $vbulletin->GPC['perpage'] . "\">" . $vbphrase['click_here_to_continue_processing'] . "</a></p>";
	}
	else
	{
		define('CP_REDIRECT', 'umg_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=rebuild');
		print_stop_message ('umg_admin_thumbnnails_ok');
	}
}

echo '<p align="center"><a href="http://www.php-unlimited.com/" target="_blank" class="copyright">Ultimate Media Gallery v' . $umgv . ', Copyright &copy;2008-2009, pHp-unlimited.com</a></p>';
print_cp_footer ();
?>
